/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLMetadataSubelements;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.events.IFormElementWithKeySupport;
import pl.fhframework.events.OnKeyEvent;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.Form;

public abstract class BaseInputFieldWithKeySupport
extends BaseInputField
implements IFormElementWithKeySupport {
    @XMLProperty
    @DocumentedComponentAttribute(value="Represents use case's action executed each time key(s) defined in 'keyEvent' are being pressed.")
    @DesignerXMLProperty(priority=120, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    private ActionBinding onKeyEvent;
    @XMLProperty
    @DesignerXMLProperty(priority=121, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="Defines pipe-separated list of key definitions that will call 'onKeyEvent' action. Eg. ENTER or ENTER|CTRL+ALT+A|CTRL+B|SPACE")
    private String keyEvent;
    @XMLMetadataSubelements
    private List<OnKeyEvent> keyEventHandlers = new ArrayList<OnKeyEvent>();

    public BaseInputFieldWithKeySupport(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        this.initKeyHandlers();
    }

    @Override
    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        Optional keyHandler = this.getKeyEventHandler(eventData);
        if (keyHandler.isPresent()) {
            return keyHandler;
        }
        return super.getEventHandler(eventData);
    }

    public void setOnKeyEvent(ActionBinding onKeyEvent) {
        this.onKeyEvent = onKeyEvent;
    }

    public IActionCallbackContext setOnKeyEvent(IActionCallback onKeyEvent) {
        return CallbackActionBinding.createAndSet((IActionCallback)onKeyEvent, this::setOnKeyEvent);
    }

    public ActionBinding getOnKeyEvent() {
        return this.onKeyEvent;
    }

    public String getKeyEvent() {
        return this.keyEvent;
    }

    public void setKeyEvent(String keyEvent) {
        this.keyEvent = keyEvent;
    }

    public List<OnKeyEvent> getKeyEventHandlers() {
        return this.keyEventHandlers;
    }

    public void setKeyEventHandlers(List<OnKeyEvent> keyEventHandlers) {
        this.keyEventHandlers = keyEventHandlers;
    }
}

