/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.formatters;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.springframework.util.StringUtils;
import pl.fhframework.format.AutoRegisteredFormatter;
import pl.fhframework.format.FhFormatter;

@FhFormatter(value="bigDecimalFormatter")
public class BigDecimalFormatter
extends AutoRegisteredFormatter<BigDecimal> {
    private static ThreadLocal<DecimalFormat> customFormat = ThreadLocal.withInitial(() -> new DecimalFormat(){
        {
            DecimalFormatSymbols pSymbols = this.getDecimalFormatSymbols();
            pSymbols.setDecimalSeparator(',');
            pSymbols.setGroupingSeparator(' ');
            this.setDecimalFormatSymbols(pSymbols);
            this.setGroupingUsed(false);
            this.setParseBigDecimal(true);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(2);
            this.setRoundingMode(RoundingMode.HALF_UP);
        }
    });

    public BigDecimal parse(String s, Locale locale) throws ParseException {
        if (!StringUtils.isEmpty((Object)s)) {
            s = s.replace('.', ',');
        }
        return (BigDecimal)customFormat.get().parse(s);
    }

    public String print(BigDecimal value, Locale locale) {
        String pRetVal = "";
        if (value != null) {
            pRetVal = customFormat.get().format(value);
        }
        return pRetVal;
    }
}

