/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.CompiledBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.AccessibilityEnum;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.IPairableComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.InputFieldDesignerPreviewProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.validation.ValidationFactory;
import pl.fhframework.validation.ValidationManager;

@TemplateControl(tagName="fh-radio-option")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="RadioOption represents single radio component", icon="fa fa-circle", ignoreFields={"emptyValue", "emptyLabel"})
public class RadioOption
extends BaseInputField
implements IPairableComponent<String> {
    private static final String GROUP_VALUE_ATTR = "targetValue";
    private static final String CHECKED_ATTR = "checkedRadio";
    @JsonIgnore
    @XMLProperty(required=true, value="targetValue")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=InputFieldDesignerPreviewProvider.class, priority=80, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Target value for group of RadioOption controls")
    private ModelBinding groupModelBinding;
    @JsonIgnore
    private String targetValue;
    @JsonIgnore
    private boolean checkedRadio;
    private String groupName;

    public RadioOption(Form form) {
        super(form);
    }

    @Override
    public RadioOption createNewSameComponent() {
        return new RadioOption(this.getForm());
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        if (this.groupModelBinding != null && !valueChange.getChangedAttributes().isEmpty()) {
            this.updateBinding(valueChange, this.groupModelBinding, this.groupModelBinding.getBindingExpression(), this.getOptionalFormatter());
        }
    }

    public void setPairData(String data) {
        this.groupName = String.valueOf(data);
    }

    @JsonIgnore
    public String getPairDiscriminator() {
        int resultHash;
        if (this.groupModelBinding instanceof CompiledBinding) {
            resultHash = Objects.hash(((CompiledBinding)this.groupModelBinding).getTargetType(), this.groupModelBinding.getBindingResult().getAttributeName());
        } else if (this.groupModelBinding instanceof StaticBinding) {
            resultHash = Objects.hash(((StaticBinding)this.groupModelBinding).getStaticValue());
        } else {
            return UUID.randomUUID().toString();
        }
        return String.valueOf(resultHash);
    }

    public boolean isChecked() {
        if (this.groupModelBinding == null || this.getModelBinding() == null) {
            return false;
        }
        Object a1 = this.groupModelBinding.getBindingResult().getValue();
        Object a2 = this.getModelBinding().getBindingResult().getValue();
        if (a1 == null || a2 == null) {
            return false;
        }
        return a1.equals(a2);
    }

    @Override
    protected void checkBinding() {
        if (!(this.getAvailability() != null && this.getAvailability() != AccessibilityEnum.EDIT || this.groupModelBinding == null || this.groupModelBinding.canChange())) {
            this.setAvailability(AccessibilityEnum.VIEW);
        }
    }

    @Override
    protected String convertToRaw(BindingResult<?> bindingResult) {
        if (bindingResult == null) {
            return "";
        }
        Optional converterName = this.getOptionalFormatter();
        if (!converterName.isPresent() && bindingResult.getValue() instanceof Enum) {
            return ((Enum)bindingResult.getValue()).name();
        }
        return this.convertBindingValueToString(bindingResult, converterName);
    }

    @Override
    protected ValidationManager<BaseInputField> createValidationManager() {
        return ValidationFactory.getInstance().getRadioOptionValidationProcess();
    }

    @Override
    protected ModelBinding getTargetModelBinding() {
        return this.getGroupModelBinding();
    }

    @Override
    @JsonIgnore
    public List<ModelBinding> getAllBingings() {
        List<ModelBinding> allBindings = super.getAllBingings();
        allBindings.add(this.getGroupModelBinding());
        return allBindings;
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.processValue(elementChanges);
        return elementChanges;
    }

    private void processValue(ElementChanges elementChanges) {
        String newLabelValue;
        BindingResult bindingResult;
        BindingResult bindingResult2 = bindingResult = this.groupModelBinding != null ? this.groupModelBinding.getBindingResult() : null;
        if (bindingResult != null && !this.areValuesTheSame(newLabelValue = this.convertValueToString(bindingResult.getValue()), this.targetValue)) {
            this.refreshView();
            this.targetValue = newLabelValue;
            boolean isChecked = this.isChecked();
            if (!this.areValuesTheSame(isChecked, this.checkedRadio)) {
                this.checkedRadio = isChecked;
                elementChanges.addChange(CHECKED_ATTR, (Object)this.checkedRadio);
            }
        }
    }

    public ModelBinding getGroupModelBinding() {
        return this.groupModelBinding;
    }

    public void setGroupModelBinding(ModelBinding groupModelBinding) {
        this.groupModelBinding = groupModelBinding;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public boolean isCheckedRadio() {
        return this.checkedRadio;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}

