/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.IndexedModelBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.core.FhException;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.util.CollectionsUtils;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.ColumnPaged;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PageModel;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.attribute.CommaSeparatedStringListAttrConverter;
import pl.fhframework.model.forms.config.BasicControlsConfiguration;
import pl.fhframework.model.forms.utils.LanguageResolver;

@Control(parents={GroupingComponent.class}, invalidParents={Table.class}, canBeDesigned=true)
@OverridenPropertyAnnotations(property="collection", designerXmlProperty={@DesignerXMLProperty(allowedTypes={Page.class, PageModel.class}, commonUse=true, bindingOnly=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=15)})
@DocumentedComponent(category=DocumentedComponent.Category.TABLE_AND_TREE, documentationExample=true, value="Table that allows to arrange data like text, images, links, other tables, etc. into rows and columns of cells inside of page.", icon="fa fa-table")
public class TablePaged
extends Table {
    private static final String SORT_BY_ATTRIBUTE = "sortBy";
    private static final String DIRECTION_ATTRIBUTE = "direction";
    private static final String CURRENT_PAGE_ATTRIBUTE = "currentPage";
    private static final String PAGE_SIZE_ATTRIBUTE = "pageSize";
    private static final String PAGE_SIZES_ATTRIBUTE = "pageSizes";
    private PageRequest pageable = null;
    private int totalPages;
    private long totalRows;
    private int pageNumber;
    @XMLProperty(defaultValue="10")
    @DocumentedComponentAttribute(value="Amount of records displayed on single page")
    private int pageSize;
    @JsonIgnore
    private Page currentPage;
    @JsonIgnore
    private PageModel pageModel;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="-")
    @DocumentedComponentAttribute(defaultValue="-", value="If the table page is changed that method will be executed")
    private ActionBinding onPageChange;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="-")
    @DocumentedComponentAttribute(defaultValue="-", value="If the table page size is changed that method will be executed")
    private ActionBinding onPageSizeChange;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="-")
    @DocumentedComponentAttribute(defaultValue="-", value="If the table page sorting is changed that method will be executed")
    private ActionBinding onSortChange;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty
    @DocumentedComponentAttribute(value="Property name by default passed in the Pageable object to be interpreted in a data source (eg. DAO)")
    private String defaultSortBy;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="true")
    @DocumentedComponentAttribute(value="If defaultSortBy is set this property decides if default order is ascending ", defaultValue="true")
    private boolean defaultSortByAsc = true;
    @XMLProperty(defaultValue="false")
    @DocumentedComponentAttribute(value="Add additional pagination and page size select above the table")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=16)
    private boolean paginationAboveTable = false;
    @XMLProperty(required=false)
    @DocumentedComponentAttribute(value="Change page size select into button group.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=17)
    private Boolean pageSizeAsButtons = null;
    private List<String> pageSizes = null;
    @JsonIgnore
    @XMLProperty(value="pageSizes", required=false)
    @DocumentedComponentAttribute(value="Define possible page sizes. Coma separated. Default value is 5,10,15,25")
    @DesignerXMLProperty(allowedTypes={Collection.class, String.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=17)
    private ModelBinding pageSizesModelBinding;
    private String language;
    private static final int PAGE_START = 0;
    private static final String ON_PAGE_CHANGE = "onPageChange";
    private static final String ON_SORT_CHANGE = "onSortChange";
    private static final String ON_PAGE_SIZE_CHANGE = "onPageSizeChange";
    private static final String DISPLAYED_PAGE_NUMBER = "pageNumber";
    private static final String DISPLAYED_PAGE_SIZE = "pageSize";
    private static final String DISPLAYED_TOTAL_PAGES = "totalPages";
    private static final String DISPLAYED_TOTAL_ROWS = "totalRows";

    public TablePaged(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        if (this.pageSize < 1) {
            this.pageSize = 10;
        }
        this.pageNumber = 0;
        this.changePageOrSize(this.pageNumber, this.pageSize);
        if (this.pageSizeAsButtons == null) {
            this.setPageSizeAsButtons(BasicControlsConfiguration.getInstance().getTablePagedPageSizeAsButtons());
        }
        this.pageSizes = new CommaSeparatedStringListAttrConverter().fromXML((Component)this, BasicControlsConfiguration.getInstance().getTablePagedPageSizes());
    }

    @Override
    public int getRowNumberOffset() {
        return this.pageSize * this.pageNumber;
    }

    @Override
    protected Collection extractCollection(IndexedModelBinding collectionBinding, int[] parentIteratorIndices, boolean isMainLevel) {
        if (isMainLevel) {
            Object bindingResultObj = collectionBinding.getValue(parentIteratorIndices);
            if (bindingResultObj != null) {
                return this.extractMainCollection(collectionBinding, bindingResultObj);
            }
            return null;
        }
        return super.extractCollection(collectionBinding, parentIteratorIndices, isMainLevel);
    }

    private Collection extractMainCollection(IndexedModelBinding collectionBinding, Object bindingResultObj) {
        if (bindingResultObj instanceof PageModel) {
            PageModel pageModel;
            this.pageModel = pageModel = (PageModel)bindingResultObj;
            if (this.pageModel.isResetNeeded()) {
                this.changePageOrSize(0, this.pageSize);
            }
            if (this.pageModel.isRefreshNeeded()) {
                this.pageModel.doRefresh((Pageable)this.pageable);
            }
            this.currentPage = pageModel.getPage();
            return this.extractMainCollection();
        }
        if (bindingResultObj instanceof Page) {
            this.currentPage = (Page)bindingResultObj;
            return this.extractMainCollection();
        }
        throw new FhException("Not instance of PageModel: " + collectionBinding.getBindingExpression());
    }

    private Collection extractMainCollection() {
        this.mainCollection = this.currentPage.getContent();
        return this.mainCollection;
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        String newTextValue;
        if (valueChange.hasMainValueChanged() && this.containsNumeric(valueChange.getMainValue()) && this.getSelectedElementBinding() != null && (newTextValue = valueChange.getMainValue()) != null) {
            Object newSelectedElement;
            newTextValue = newTextValue.substring(1, newTextValue.length() - 1);
            this.selectedRowsNumbers = Arrays.stream(newTextValue.split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
            Collection<Object> bindedObjectsList = this.getBindedObjectsList();
            if (this.isMultiselect()) {
                newSelectedElement = this.getSelectedElementsBasedOnRowsNumbers(bindedObjectsList, this.selectedRowsNumbers);
                if (this.getSelectedElementBinding().getBindingResult() != null) {
                    Collection muliselectCol = (Collection)this.getSelectedElementBinding().getBindingResult().getValue();
                    if (muliselectCol != null) {
                        muliselectCol.removeAll(bindedObjectsList);
                        muliselectCol.addAll((Collection)newSelectedElement);
                    } else {
                        this.getSelectedElementBinding().setValue(newSelectedElement);
                    }
                } else {
                    this.getSelectedElementBinding().setValue(newSelectedElement);
                }
            } else {
                newSelectedElement = this.selectedRowsNumbers[0] > -1 && bindedObjectsList.size() > this.selectedRowsNumbers[0] ? CollectionsUtils.get(bindedObjectsList, (int)this.selectedRowsNumbers[0]) : null;
                this.getSelectedElementBinding().setValue(newSelectedElement);
            }
        }
        boolean refreshNeeded = false;
        if (valueChange.hasAttributeChanged(CURRENT_PAGE_ATTRIBUTE)) {
            int pageNumber = valueChange.getIntAttribute(CURRENT_PAGE_ATTRIBUTE);
            this.changePageOrSize(pageNumber, this.pageable.getPageSize());
            refreshNeeded = true;
        }
        if (valueChange.hasAttributeChanged(SORT_BY_ATTRIBUTE)) {
            String sortBy = valueChange.getStringAttribute(SORT_BY_ATTRIBUTE);
            String directionString = valueChange.getStringAttribute(DIRECTION_ATTRIBUTE);
            Sort.Direction direction = directionString != null ? Sort.Direction.valueOf((String)directionString) : null;
            ColumnPaged column = (ColumnPaged)this.getSortingColumn(sortBy, this.getColumns());
            this.pageable = PageRequest.of((int)this.pageNumber, (int)this.pageable.getPageSize(), (Sort.Direction)direction, (String[])new String[]{column.getSortBy()});
            refreshNeeded = true;
        }
        if (valueChange.hasAttributeChanged("pageSize")) {
            int pageSize = valueChange.getIntAttribute("pageSize");
            this.changePageOrSize(0, pageSize);
            refreshNeeded = true;
        }
        if (refreshNeeded && this.pageModel != null) {
            this.pageModel.refreshNeeded();
        }
    }

    public boolean containsNumeric(String text) {
        int endIdx;
        if (text == null) {
            return false;
        }
        int startIdx = text.indexOf("[");
        if (startIdx > (endIdx = text.indexOf("]"))) {
            FhLogger.error((String)"Could not retrieve numeric value from passed String: {}", (Object[])new Object[]{text});
            return false;
        }
        return text != null && text.matches(".*\\d.*");
    }

    @Override
    public ElementChanges updateView() {
        BindingResult pageSizesModelBindingResult;
        ElementChanges elementChange = super.updateView();
        if (this.currentPage != null && this.totalPages != this.currentPage.getTotalPages()) {
            this.totalPages = this.currentPage.getTotalPages();
            elementChange.addChange(DISPLAYED_TOTAL_PAGES, (Object)this.totalPages);
        }
        if (this.currentPage != null && this.totalRows != this.currentPage.getTotalElements()) {
            this.totalRows = this.currentPage.getTotalElements();
            elementChange.addChange(DISPLAYED_TOTAL_ROWS, (Object)this.totalRows);
        }
        if (this.currentPage != null && this.pageNumber != this.currentPage.getNumber()) {
            this.pageNumber = this.currentPage.getNumber();
            elementChange.addChange(DISPLAYED_PAGE_NUMBER, (Object)this.pageNumber);
            if (this.pageNumber != this.pageable.getPageNumber()) {
                this.changePageOrSize(this.pageNumber, this.pageable.getPageSize());
            }
        }
        if (this.pageSize != this.pageable.getPageSize()) {
            if (this.getForm().getViewMode() == Form.ViewMode.DESIGN) {
                this.changePageOrSize(0, this.pageSize);
            } else {
                this.pageSize = this.pageable.getPageSize();
            }
            elementChange.addChange("pageSize", (Object)this.pageSize);
            this.pageNumber = this.pageable.getPageNumber();
            elementChange.addChange(DISPLAYED_PAGE_NUMBER, (Object)this.pageNumber);
        }
        if (this.pageSizesModelBinding != null && (pageSizesModelBindingResult = this.pageSizesModelBinding.getBindingResult()) != null) {
            List valuesAsList;
            Object value = pageSizesModelBindingResult.getValue();
            if (value instanceof String) {
                String valuesAsString = (String)value;
                List allValues = new CommaSeparatedStringListAttrConverter().fromXML((Component)this, valuesAsString);
                if (allValues.size() > 0 && !Objects.equals(this.pageSizes, allValues)) {
                    this.pageSizes = allValues;
                    elementChange.addChange(PAGE_SIZES_ATTRIBUTE, this.pageSizes);
                }
            } else if (value instanceof List && (valuesAsList = (List)value).size() > 0 && !Objects.equals(this.pageSizes, valuesAsList)) {
                this.pageSizes = valuesAsList;
                elementChange.addChange(PAGE_SIZES_ATTRIBUTE, this.pageSizes);
            }
        }
        this.language = LanguageResolver.languageChanges(this.getForm().getAbstractUseCase().getUserSession(), this.language, elementChange);
        return elementChange;
    }

    @Override
    protected Collection<Object> getBindedObjectsList() {
        if (this.getCollection() == null) {
            throw new FhBindingException("Table '" + this.getId() + "' has not binding for 'collection'!");
        }
        Object list = this.getCollection().getBindingResult().getValue();
        if (list != null) {
            if (list instanceof Collection) {
                return (Collection)list;
            }
            if (list instanceof Page && ((Page)list).getContent() != null) {
                return ((Page)list).getContent();
            }
            if (list instanceof PageModel && ((PageModel)list).getPage() != null && ((PageModel)list).getPage().getContent() != null) {
                return ((PageModel)list).getPage().getContent();
            }
            if (!(list instanceof Page) && !(list instanceof PageModel)) {
                throw new FhBindingException("Binded for table '" + this.getId() + "' class object '" + list.getClass().getSimpleName() + "' is not a Collection nor Page!");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        FhLogger.trace(((Object)((Object)this)).getClass(), logger -> logger.log("TablePaged will handle {}", new Object[]{this.selectedRowsNumbers[0]}));
        if (ON_PAGE_CHANGE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onPageChange);
        }
        if (ON_SORT_CHANGE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onSortChange);
        }
        if (ON_PAGE_SIZE_CHANGE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onPageSizeChange);
        }
        return super.getEventHandler(eventData);
    }

    public void setOnPageChange(ActionBinding onPageChange) {
        this.onPageChange = onPageChange;
    }

    public IActionCallbackContext setOnPageChange(IActionCallback onPageChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onPageChange, this::setOnPageChange);
    }

    public void setOnPageSizeChange(ActionBinding onPageSizeChange) {
        this.onPageSizeChange = onPageSizeChange;
    }

    public IActionCallbackContext setOnPageSizeChange(IActionCallback onPageSizeChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onPageSizeChange, this::setOnPageSizeChange);
    }

    public void setOnSortChange(ActionBinding onSortChange) {
        this.onSortChange = onSortChange;
    }

    public IActionCallbackContext setOnSortChange(IActionCallback onSortChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onSortChange, this::setOnSortChange);
    }

    @Override
    protected ColumnPaged createExampleColumn(int nameSuffix) {
        ColumnPaged column = new ColumnPaged(this.getForm());
        column.setLabelModelBinding((ModelBinding)new StaticBinding((Object)("Column " + nameSuffix)));
        column.setTable(this);
        column.setGroupingParentComponent((IGroupingComponent)this);
        column.init();
        return column;
    }

    private void changePageOrSize(int newPageNumber, int newPageSize) {
        Sort.Order order = this.getSortingOrder();
        this.pageable = order != null ? PageRequest.of((int)newPageNumber, (int)newPageSize, (Sort.Direction)order.getDirection(), (String[])new String[]{order.getProperty()}) : PageRequest.of((int)newPageNumber, (int)newPageSize);
    }

    private Sort.Order getSortingOrder() {
        if (this.pageable != null && this.pageable.getSort() != null && !this.pageable.getSort().isEmpty()) {
            Iterator orderIterator = this.pageable.getSort().iterator();
            return (Sort.Order)orderIterator.next();
        }
        if (this.defaultSortBy != null) {
            return new Sort.Order(this.defaultSortByAsc ? Sort.Direction.ASC : Sort.Direction.DESC, this.defaultSortBy);
        }
        return null;
    }

    private Column getSortingColumn(String sortBy, List<? extends Component> components) {
        for (Component component : components) {
            Column nestedColumn;
            if (!(component instanceof Column)) continue;
            Column column = (Column)component;
            if (sortBy.equals(column.getId())) {
                return column;
            }
            if (column.getSubcomponents() == null || (nestedColumn = this.getSortingColumn(sortBy, column.getSubcomponents())) == null) continue;
            return nestedColumn;
        }
        return null;
    }

    public PageRequest getPageable() {
        return this.pageable;
    }

    public void setPageable(PageRequest pageable) {
        this.pageable = pageable;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public PageModel getPageModel() {
        return this.pageModel;
    }

    public ActionBinding getOnPageChange() {
        return this.onPageChange;
    }

    public ActionBinding getOnPageSizeChange() {
        return this.onPageSizeChange;
    }

    public ActionBinding getOnSortChange() {
        return this.onSortChange;
    }

    public String getDefaultSortBy() {
        return this.defaultSortBy;
    }

    public void setDefaultSortBy(String defaultSortBy) {
        this.defaultSortBy = defaultSortBy;
    }

    public boolean isDefaultSortByAsc() {
        return this.defaultSortByAsc;
    }

    public void setDefaultSortByAsc(boolean defaultSortByAsc) {
        this.defaultSortByAsc = defaultSortByAsc;
    }

    public boolean isPaginationAboveTable() {
        return this.paginationAboveTable;
    }

    public void setPaginationAboveTable(boolean paginationAboveTable) {
        this.paginationAboveTable = paginationAboveTable;
    }

    public Boolean getPageSizeAsButtons() {
        return this.pageSizeAsButtons;
    }

    public void setPageSizeAsButtons(Boolean pageSizeAsButtons) {
        this.pageSizeAsButtons = pageSizeAsButtons;
    }

    public List<String> getPageSizes() {
        return this.pageSizes;
    }

    public ModelBinding getPageSizesModelBinding() {
        return this.pageSizesModelBinding;
    }

    @JsonIgnore
    public void setPageSizesModelBinding(ModelBinding pageSizesModelBinding) {
        this.pageSizesModelBinding = pageSizesModelBinding;
    }

    public String getLanguage() {
        return this.language;
    }
}

