/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.rules.buildin;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import pl.fhframework.core.FhException;
import pl.fhframework.core.maps.features.ArcGisFeature;
import pl.fhframework.core.maps.features.IFeature;
import pl.fhframework.core.rules.BusinessRule;

@BusinessRule(categories={"esri"})
public class FeatureToEsri {
    public List<ArcGisFeature> convertIFeatureToArcGisFeature(List<IFeature> features) {
        ArrayList<ArcGisFeature> convertedFeatures = new ArrayList<ArcGisFeature>();
        for (IFeature feature : features) {
            ArcGisFeature arcGisFeature = new ArcGisFeature();
            List<Geometry> geometry = this.determineGeometryType(feature);
            geometry = this.createEsriFeature(geometry, feature);
            for (int a = 0; a < geometry.size(); ++a) {
                arcGisFeature.setGeometry(geometry.get(0));
                this.writeEsriAttributes(arcGisFeature, feature);
                convertedFeatures.add(arcGisFeature);
            }
        }
        return convertedFeatures;
    }

    private List<Geometry> determineGeometryType(IFeature feature) {
        switch (feature.getGeometry().getType()) {
            case "Point": {
                return Collections.singletonList(new Point());
            }
            case "LineString": {
                return Collections.singletonList(new Polyline());
            }
            case "Polygon": {
                return Collections.singletonList(new Polygon());
            }
            case "MultiPolygon": {
                return Collections.singletonList(new Polygon());
            }
        }
        throw new FhException("Passed geometry type is not handled");
    }

    private List<Geometry> createEsriFeature(List<Geometry> geometry, IFeature feature) {
        switch (geometry.get(0).getType()) {
            case Polygon: {
                List checkCoordinates = (List)((List)feature.getCoordinates().get(0)).get(0);
                if (checkCoordinates.size() > 2) {
                    ArrayList<Geometry> polygonList = new ArrayList<Geometry>();
                    List startCoordinates = (List)checkCoordinates.get(0);
                    List geometryCoordinates = checkCoordinates;
                    for (int i = 0; i < feature.getCoordinates().size(); ++i) {
                        Polygon polygon = new Polygon();
                        this.drawPolygonPath(startCoordinates, geometryCoordinates, polygon);
                        polygonList.add((Geometry)polygon);
                    }
                    return polygonList;
                }
                Polygon polygon = new Polygon();
                List startCoordinates = checkCoordinates;
                List geometryCoordinates = (List)feature.getCoordinates().get(0);
                this.drawPolygonPath(startCoordinates, geometryCoordinates, polygon);
                return Collections.singletonList(polygon);
            }
            case Polyline: {
                Polyline polyline = new Polyline();
                List lineStartCoordinates = (List)feature.getCoordinates().get(0);
                Point startDrawLine = this.createPoint(lineStartCoordinates);
                polyline.startPath(startDrawLine);
                for (int i = 1; i < feature.getCoordinates().size(); ++i) {
                    List lineCoordinates = (List)feature.getCoordinates().get(i);
                    Point nextLinePoint = this.createPoint(lineCoordinates);
                    polyline.lineTo(nextLinePoint);
                }
                return Collections.singletonList(polyline);
            }
            case Point: {
                List coordinates = feature.getCoordinates();
                return Collections.singletonList(this.createPoint(coordinates));
            }
        }
        throw new FhException("Passed geometry type is not handled");
    }

    private void drawPolygonPath(List<Double> startCoordinates, List<List<Double>> geometryCoordinates, Polygon polygon) {
        Point startPoint = this.createPoint(startCoordinates);
        polygon.startPath(startPoint);
        int geometriesSize = geometryCoordinates.size();
        for (int a = 1; a < geometriesSize; ++a) {
            if (a + 1 <= geometriesSize) {
                List<Double> coordinates = geometryCoordinates.get(a);
                Point nextPoint = this.createPoint(coordinates);
                polygon.lineTo(nextPoint);
                continue;
            }
            polygon.lineTo(startPoint);
        }
    }

    private Point createPoint(List<Double> coordinates) {
        Point endPoint2D = new Point();
        endPoint2D.setXY(coordinates.get(0).doubleValue(), coordinates.get(1).doubleValue());
        return endPoint2D;
    }

    private void writeEsriAttributes(ArcGisFeature arcGisFeature, IFeature feature) {
        Map attributes = feature.getProperties();
        arcGisFeature.setAttributes(attributes);
        arcGisFeature.getAttributes().put("shape_area", arcGisFeature.getGeometry().calculateArea2D());
        arcGisFeature.getAttributes().put("shape_length", arcGisFeature.getGeometry().calculateLength2D());
    }
}

