/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.MultiValueMap;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Combo;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Enables users to quickly find and select from a pre-populated list of values as they type, leveraging searching and filtering.", icon="fa fa-outdent")
@DesignerControl(defaultWidth=3)
@Control(parents={PanelGroup.class, Group.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
public class Select2Combo
extends Combo {
    protected static final String REMOVED_INDEX_GROUP_ATTR = "removedIndexGroup";

    public Select2Combo(Form<?> form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        this.setFilterFunction();
        this.processValuesBinding();
        this.processFiltering("");
        this.filteredValues = this.collectValues((MultiValueMap<String, Object>)this.filteredObjectValues);
    }

    @Override
    protected void processFiltering(String text) {
        Map<String, List> filtered = this.values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> ((List)p.getValue()).stream().filter(s -> this.filterFunction.test(s, text)).collect(Collectors.toList())));
        this.filteredObjectValues.clear();
        this.filteredObjectValues.putAll(filtered);
        this.filterInvoked = true;
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        Integer cursor;
        String textObj = valueChange.getStringAttribute("text");
        Boolean addedTag = valueChange.getBooleanAttribute("addedTag");
        if (textObj != null && textObj.equals("") && !this.multiselect) {
            this.cleared = true;
            this.filterText = "";
            this.processFiltering(this.filterText);
            this.selectedItemIndex = -1;
            this.selectedItem = null;
            this.rawValue = null;
            this.changeSelectedItemBinding();
        } else if (textObj != null) {
            String text;
            this.filterText = text = textObj;
            this.processFiltering(text);
            this.firstLoad = false;
            if (!this.isMultiselect()) {
                this.selectItemByFilterText();
                this.changeSelectedItemBinding();
            }
            if (this.freeTyping) {
                this.selectedItem = StringUtils.emptyToNull((String)text);
                if (this.isMultiselect() && Boolean.TRUE.equals(addedTag) && !StringUtils.isNullOrEmpty((String)this.rawValue)) {
                    this.selectedItem = this.rawValue;
                    this.changeSelectedItemBinding();
                } else {
                    this.rawValue = (String)this.selectedItem;
                }
                if (!this.isMultiselect()) {
                    this.changeSelectedItemBinding();
                }
            }
            this.updateFilterTextBinding();
        }
        Boolean cleared = valueChange.getBooleanAttribute("cleared");
        if (cleared != null && cleared.booleanValue() && textObj == null) {
            this.cleared = cleared;
            this.filterText = "";
            this.processFiltering(this.filterText);
            this.selectedItemIndex = -1;
            this.selectedItem = null;
            this.rawValue = null;
            this.multiselectRawValue = null;
            this.changeSelectedItemBinding();
            this.updateFilterTextBinding();
        } else if (valueChange.hasAttributeChanged("selectedIndex")) {
            this.cleared = false;
            String key = valueChange.getStringAttribute("selectedIndexGroup");
            this.selectedItemIndex = valueChange.getIntAttribute("selectedIndex");
            this.selectedItem = this.selectedItemIndex >= 0 ? ((List)this.filteredObjectValues.get((Object)key)).get(this.selectedItemIndex) : null;
            this.changeSelectedItemBinding();
            this.rawValue = !this.isMultiselect() && this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
            this.multiselectRawValue = this.isMultiselect() && this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
            this.filterText = this.rawValue != null ? this.rawValue : "";
            this.processFiltering(this.filterText);
            this.updateFilterTextBinding();
        }
        if (valueChange.hasAttributeChanged("removedIndex")) {
            int removedIndexAttr = valueChange.getIntAttribute("removedIndex");
            String key = valueChange.getStringAttribute(REMOVED_INDEX_GROUP_ATTR);
            List multiSelected = (List)this.getModelBinding().getBindingResult().getValue();
            multiSelected.remove(((List)this.filteredObjectValues.get((Object)key)).get(removedIndexAttr));
            this.selectedItem = new ArrayList(multiSelected);
            this.rawValue = !this.isMultiselect() && this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
            String string = this.multiselectRawValue = this.isMultiselect() && this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
        }
        if (this.cursorBinding != null && (cursor = valueChange.getIntAttribute("cursor")) != null && !Objects.equals(this.cursor, cursor)) {
            this.updateBindingForValue(cursor, this.cursorBinding, this.cursorBinding.getBindingExpression(), this.getOptionalFormatter());
            this.cursor = cursor;
        }
    }

    @Override
    protected void setFilterFunction() {
        this.filterFunction = (k, v) -> true;
    }

    @Override
    protected boolean processFilterBinding(ElementChanges elementChanges, boolean valuesChanged) {
        return false;
    }
}

