/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.fhframework.BindingResult;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.InputText;
import pl.fhframework.validation.ConstraintViolation;
import pl.fhframework.validation.Validator;

@Component
public class RegExRequired
implements Validator<BaseInputField> {
    @Autowired
    private MessageService messageService;

    public List<ConstraintViolation<BaseInputField>> validate(BaseInputField baseInputField) {
        String text;
        Object value;
        ArrayList<ConstraintViolation<BaseInputField>> violations = new ArrayList<ConstraintViolation<BaseInputField>>();
        InputText inputText = (InputText)baseInputField;
        if (StringUtils.isNullOrEmpty((String)inputText.getRequiredRegex())) {
            return violations;
        }
        BindingResult bindingResult = inputText.getModelBinding().getBindingResult();
        Object object = value = bindingResult != null ? bindingResult.getValue() : null;
        if (value != null && !(text = value.toString()).isEmpty() && !inputText.getRequiredRegexPattern().matcher(text).matches()) {
            String message = null;
            if (inputText.getRequiredRegexMessage() != null) {
                BindingResult msgBindingResult = inputText.getRequiredRegexMessage().getBindingResult();
                message = (String)msgBindingResult.getValue();
            }
            if (message == null) {
                message = this.messageService.getAllBundles().getMessage("fh.core.validation.field.regex_required", (Object[])new String[]{inputText.getRequiredRegex()});
            }
            this.addConstraintViolation(violations, inputText, message);
        }
        return violations;
    }
}

