/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.List;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.resource.ImageRepository;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;

@Control(parents={PanelGroup.class, Group.class, Column.class, Tab.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
public class ImageGrid
extends FormElement
implements IChangeableByClient {
    private static final String VALUES_ATTR = "values";
    private static final String SUBSYSTEM_ATTR = "subsystem";
    private static final String SELECTED_ITEM_ATTR = "selectedItem";
    private static final String SELECTED_INDEX_ATTR = "selectedIndex";
    @JsonIgnore
    private ImageRepository.ImageEntry selectedItem;
    @JsonIgnore
    private Integer selectedItemIndex;
    @JsonIgnore
    @XMLProperty(value="values")
    @DesignerXMLProperty(allowedTypes={List.class})
    private ModelBinding<List<ImageRepository.ImageEntry>> valuesBinding;
    private List<ImageRepository.ImageEntry> values;
    @JsonIgnore
    @XMLProperty(value="subsystem")
    @DesignerXMLProperty(allowedTypes={String.class})
    private ModelBinding<String> subsystemBinding;
    private String subsystem;
    @JsonIgnore
    @XMLProperty(value="selectedItem")
    @DocumentedComponentAttribute(boundable=true, value="Name of model object which will be used to keep information about selected item.")
    private ModelBinding<ImageRepository.ImageEntry> selectedItemBinding;

    public ImageGrid(Form form) {
        super(form);
    }

    public void updateModel(ValueChange valueChange) {
        if (valueChange.hasAttributeChanged(SELECTED_INDEX_ATTR)) {
            Integer selectedIndex = valueChange.getIntAttribute(SELECTED_INDEX_ATTR);
            if (selectedIndex != null) {
                this.selectedItemIndex = selectedIndex;
                this.selectedItem = this.values.get(this.selectedItemIndex);
                if (this.selectedItemBinding != null) {
                    this.selectedItemBinding.setValue((Object)this.selectedItem);
                }
            } else {
                this.selectedItemIndex = null;
                this.selectedItem = null;
                if (this.selectedItemBinding != null) {
                    this.selectedItemBinding.setValue(null);
                }
            }
        }
    }

    public ElementChanges updateView() {
        String newNameValue;
        BindingResult bindingResult;
        BindingResult valuesBindingResult;
        ElementChanges changes = super.updateView();
        if (this.valuesBinding != null && (valuesBindingResult = this.valuesBinding.getBindingResult()) != null && valuesBindingResult.getValue() instanceof Collection) {
            this.values = (List)valuesBindingResult.getValue();
            changes.addChange(VALUES_ATTR, this.values);
        }
        if (this.selectedItemBinding != null) {
            BindingResult selectedItemBindingResult = this.selectedItemBinding.getBindingResult();
            if (selectedItemBindingResult.getValue() == null) {
                changes.addChange(SELECTED_ITEM_ATTR, null);
                this.selectedItemIndex = null;
            } else {
                changes.addChange(SELECTED_ITEM_ATTR, (Object)this.selectedItemIndex);
            }
        }
        if (this.subsystemBinding != null && (bindingResult = this.subsystemBinding.getBindingResult()) != null && !this.areValuesTheSame(newNameValue = (String)bindingResult.getValue(), this.subsystem)) {
            this.subsystem = newNameValue;
            changes.addChange(SUBSYSTEM_ATTR, (Object)this.subsystem);
        }
        this.refreshView();
        return changes;
    }

    public ModelBinding<List<ImageRepository.ImageEntry>> getValuesBinding() {
        return this.valuesBinding;
    }

    @JsonIgnore
    public void setValuesBinding(ModelBinding<List<ImageRepository.ImageEntry>> valuesBinding) {
        this.valuesBinding = valuesBinding;
    }

    public List<ImageRepository.ImageEntry> getValues() {
        return this.values;
    }

    public ModelBinding<String> getSubsystemBinding() {
        return this.subsystemBinding;
    }

    @JsonIgnore
    public void setSubsystemBinding(ModelBinding<String> subsystemBinding) {
        this.subsystemBinding = subsystemBinding;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public ModelBinding<ImageRepository.ImageEntry> getSelectedItemBinding() {
        return this.selectedItemBinding;
    }

    @JsonIgnore
    public void setSelectedItemBinding(ModelBinding<ImageRepository.ImageEntry> selectedItemBinding) {
        this.selectedItemBinding = selectedItemBinding;
    }
}

