/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.util.JDBCExceptionReporter;
import org.springframework.orm.hibernate.LocalSessionFactoryBean;

public class LocalDataSourceConnectionProvider
implements ConnectionProvider {
    private DataSource dataSource;

    public void configure(Properties props) throws HibernateException {
        this.dataSource = LocalSessionFactoryBean.getConfigTimeDataSource();
        if (this.dataSource == null) {
            throw new HibernateException("No local DataSource found for configuration - dataSource property must be set on LocalSessionFactoryBean");
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions((SQLException)sqle);
            throw sqle;
        }
    }

    public void closeConnection(Connection conn) throws SQLException {
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions((SQLException)sqle);
            throw sqle;
        }
    }

    public void close() {
    }
}

